/**
 * 
 */
package com.ejie.ab18a.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.w3c.dom.Document;

import com.ejie.ab18a.combo.Ab18aObjetoWSBean;
import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aEstadoPeticion;
import com.ejie.ab18a.model.Ab18aEstadoTramitacion;
import com.ejie.ab18a.model.Ab18aFiltroMonitor;
import com.ejie.ab18a.model.Ab18aTipoBoletin;
import com.ejie.ab18a.model.Ab18aTipoPeticion;
import com.ejie.ab18a.service.Ab18aEstadoPeticionService;
import com.ejie.ab18a.service.Ab18aEstadoTramitacionService;
import com.ejie.ab18a.service.Ab18aTipoBoletinService;
import com.ejie.ab18a.service.Ab18aTipoPeticionService;
import com.ejie.ab18a.utils.Ab18aAccesoWS;
import com.ejie.ab18a.utils.Ab18aConvertirJaxb;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.x38.security.UserCredentials;
import com.ejie.xmlbeans.ServicioObtencionPerfilesUsuarios;
import com.ejie.xmlbeans.TipoPerfil;

/**
 * @author XXXX
 * 
 */
@Controller()
@RequestMapping(value = "/combo")
@SessionAttributes(value = "filtroMonitor")
public class Ab18aComboController {

	private static final Logger logger = LoggerFactory.getLogger(Ab18aComboController.class);

	/** Services **/
	@Autowired()
	private Ab18aTipoBoletinService ab18aTipoBoletinService;

	@Autowired()
	private Ab18aTipoPeticionService ab18aTipoPeticionService;

	@Autowired()
	private Ab18aEstadoPeticionService ab18aEstadoPeticionService;

	@Autowired()
	private Ab18aEstadoTramitacionService ab18aEstadoTramitacionService;

	@SuppressWarnings("finally")
	@RequestMapping(value = "tiposBoletin", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aTipoBoletin> getTiposBoletin() {
		List<Ab18aTipoBoletin> listaTiposBoletin = new ArrayList<Ab18aTipoBoletin>();
		try {
			listaTiposBoletin = this.ab18aTipoBoletinService.findAll(new Ab18aTipoBoletin(), null);
			Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de tipos de boletín");
		} catch (Exception e) {
			Ab18aComboController.logger.error("Ab18aComboController - getTiposBoletin(): Error al recuperar la lista de tipos de boletín, " + e);
		} finally {
			return listaTiposBoletin;
		}
	}

	@SuppressWarnings("finally")
	@RequestMapping(value = "tiposPeticion", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aTipoPeticion> getTiposPeticion() {
		List<Ab18aTipoPeticion> listaTiposPeticion = new ArrayList<Ab18aTipoPeticion>();
		try {
			listaTiposPeticion = this.ab18aTipoPeticionService.findAll(new Ab18aTipoPeticion(), null);
			Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de tipos de peticion");
		} catch (Exception e) {
			Ab18aComboController.logger.error("Ab18aComboController - getTiposPeticion(): Error al recuperar la lista de tipos de petición, " + e);
		} finally {
			return listaTiposPeticion;
		}
	}

	@SuppressWarnings("finally")
	@RequestMapping(value = "estadosPeticion", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aEstadoPeticion> getEstadosPeticion() {
		List<Ab18aEstadoPeticion> listaEstadosPeticion = new ArrayList<Ab18aEstadoPeticion>();
		try {
			listaEstadosPeticion = this.ab18aEstadoPeticionService.findAll(new Ab18aEstadoPeticion(), null);
			Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de tipos de peticion");
		} catch (Exception e) {
			Ab18aComboController.logger.error("Ab18aComboController - getEstadosPeticion(): Error al recuperar la lista de tipos de petición, " + e);
		} finally {
			return listaEstadosPeticion;
		}
	}

	@SuppressWarnings("finally")
	@RequestMapping(value = "estadosTramitacion", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aEstadoTramitacion> getEstadosTramitacion() {
		List<Ab18aEstadoTramitacion> listaEstadosTramitacion = new ArrayList<Ab18aEstadoTramitacion>();
		try {
			listaEstadosTramitacion = this.ab18aEstadoTramitacionService.findAllMonitor(new Ab18aEstadoTramitacion(), null);
			Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de estados de tramitación");
		} catch (Exception e) {
			Ab18aComboController.logger
					.error("Ab18aComboController - getEstadosTramitacion(): Error al recuperar la lista de estados de tramitación, " + e);
		} finally {
			return listaEstadosTramitacion;
		}
	}

	@SuppressWarnings("finally")
	@RequestMapping(value = "poderAdjudicador", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aObjetoWSBean> getPoderAdjudicador(@ModelAttribute() Ab18aFiltroMonitor filtroMonitor, HttpServletRequest request) {
		List<Ab18aObjetoWSBean> listaPoderAdjudicador = new ArrayList<Ab18aObjetoWSBean>();
		HttpSession session = request.getSession();
		Ab18aUsuario usuario = (Ab18aUsuario) session.getAttribute("usuario");

		try {
			if (Utilidades.notNullAndNotEmpty(usuario)) {
				String dniUsuario = usuario.getDni();

				Iterator<TipoPerfil> iteratorPerfil = usuario.getPerfiles().iterator();
				while (iteratorPerfil.hasNext()) {
					TipoPerfil perfilaux = iteratorPerfil.next();

					if (perfilaux.getCodigoPerfil().equals(Constantes.COD_ADMINISTRADOR_PERFIL)) {
						dniUsuario = "";
					}
				}
				listaPoderAdjudicador = Utilidades.obtenerListaPoderes(dniUsuario, filtroMonitor.getIdAmbito(), Constantes.CTE_FALSE,
						Utilidades.getIdiomaActual());
				Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de poderes adjudicadores");
			}
		} catch (Exception e) {
			Ab18aComboController.logger.error("Ab18aComboController - getPoderAdjudicador(): Error al recuperar la lista de poderes adjudicadores, "
					+ e);
		} finally {
			return listaPoderAdjudicador;
		}
	}

	@SuppressWarnings("finally")
	@RequestMapping(value = "entidadImpulsora", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aObjetoWSBean> getEntidadTramitadora(@ModelAttribute() Ab18aFiltroMonitor filtroMonitor, HttpServletRequest request) {
		List<Ab18aObjetoWSBean> listaEntidades = new ArrayList<Ab18aObjetoWSBean>();
		HttpSession session = request.getSession();
		Ab18aUsuario usuario = (Ab18aUsuario) session.getAttribute("usuario");
		// llamada al ws:
		try {
			String idPoderAdj = filtroMonitor.getIdPoder();

			String tipoDecreto = "";

			if (null != filtroMonitor.getTipoDecreto() && filtroMonitor.getTipoDecreto().intValue() == Constantes.ID_DECRETO_ACTUAL.intValue()) {
				tipoDecreto = Constantes.DECRETO_ACTUAL;
			}

			String dniUsuario = usuario.getDni();

			Iterator<TipoPerfil> iteratorPerfil = usuario.getPerfiles().iterator();
			while (iteratorPerfil.hasNext()) {
				TipoPerfil perfilaux = iteratorPerfil.next();

				if (perfilaux.getCodigoPerfil().equals(Constantes.COD_ADMINISTRADOR_PERFIL)) {
					dniUsuario = "";
				}
			}

			String idioma = Utilidades.getIdiomaActual();

			String[] params = { "usuario", "idPoderAdj", "idioma", "tipoDecreto" };
			String[] values = { dniUsuario, idPoderAdj, idioma, tipoDecreto };

			Ab18aComboController.logger.debug("obtenerEntidadesImpulsorasOSBUS NC tipoDecreto:" + tipoDecreto);

			String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerEntidadesImpulsorasOSBUS", params, values);

			Document doc = Utilidades.string2Document(resultado);
			listaEntidades = Utilidades.obtenerValorXML(doc);

		} catch (Exception e) {
			Ab18aComboController.logger.error("Se ha producido un error en el comboEntidad", e);
		}

		return listaEntidades;
	}

	@RequestMapping(value = "organo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ab18aObjetoWSBean> getOrgano(@ModelAttribute() Ab18aFiltroMonitor filtroMonitor, HttpServletRequest request) {

		List<Ab18aObjetoWSBean> lista = null;
		// llamada al ws:
		try {
			String entidad = filtroMonitor.getIdEntidadImpulsora();
			String idioma = Utilidades.getIdiomaActual();

			String[] params = { "entidad", "idioma" };
			String[] values = { entidad, idioma };

			String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerOrganosOSBUS", params, values);

			Document doc = Utilidades.string2Document(resultado);
			lista = Utilidades.obtenerValorXML(doc);

		} catch (Exception e) {
			Ab18aComboController.logger.error("Se ha producido un error en el comboOrgano", e);
		}

		return lista;
	}

	@RequestMapping(value = "informacionUsuario", method = RequestMethod.GET)
	public @ResponseBody()
	void getInformacionUsuario(HttpServletRequest request) {
		HttpSession session = request.getSession();

		if (session.getAttribute("usuario") == null) {
			UserCredentials userCredentials = null;
			userCredentials = (UserCredentials) SecurityContextHolder.getContext().getAuthentication().getCredentials();
			String dniUsuarioLogeado = Utilidades.calculoLetraDNI(userCredentials.getNif());
			ServicioObtencionPerfilesUsuarios perfil = null;
			Ab18aUsuario usuario = new Ab18aUsuario();
			try {
				String[] params = { "dni" };
				String[] values = { dniUsuarioLogeado };

				String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerPerfilesUsuariosOSBUS", params, values);

				Ab18aConvertirJaxb conversion = new Ab18aConvertirJaxb();

				if (resultado != null) {
					perfil = conversion.xmlToPerfiles(resultado);
				}

				if (perfil != null && perfil.getIdUsuario() != 0) {

					usuario.setDni(dniUsuarioLogeado);
					Utilidades.rellenarUsuario(usuario, perfil);

					session.setAttribute("usuario", usuario);
				}
			} catch (Exception e) {
				logger.error("Error al obtener el usuario getInformacionUsuario:\t" + e.getMessage());
			}
			Ab18aComboController.logger.info("[GET - jqGrid] : Rellenado el combo de estados de tramitación");
		}
	}

	/**
	 * @param ab18aTipoBoletinService
	 *            the ab18aTipoBoletinService to set
	 */
	public void setAb18aTipoBoletinService(Ab18aTipoBoletinService ab18aTipoBoletinService) {
		this.ab18aTipoBoletinService = ab18aTipoBoletinService;
	}
}
